<?php
/**
 * Plugin Name: Custom Order Weight Column (HPOS)
 * Description: Ajoute une colonne de poids total dans le tableau des commandes WooCommerce en admin (compatible HPOS).
 * Author: Antoine TOURNAIRE
 * Version: 1.1
 */

// Empêche l'accès direct
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Ajouter la nouvelle colonne pour le poids des commandes (HPOS compatible)
 */
add_filter('manage_woocommerce_page_wc-orders_columns', 'add_order_weight_column_hpos', 15);
function add_order_weight_column_hpos($columns) {
    $new_columns = array();
    foreach ($columns as $key => $column) {
        $new_columns[$key] = $column;
        if ('order_total' === $key) {
            $new_columns['order_weight'] = __('Poids', 'your-textdomain');
        }
    }
    return $new_columns;
}

/**
 * Afficher le poids total de la commande (HPOS: $order est un objet WC_Order)
 */
add_action('manage_woocommerce_page_wc-orders_custom_column', 'show_order_weight_column_hpos', 10, 2);
function show_order_weight_column_hpos($column, $order) {
    if ('order_weight' === $column) {
        if (!$order) {
            echo 'N/A';
            return;
        }

        $total_weight = 0;
        foreach ($order->get_items() as $item) {
            $product = $item->get_product();
            if ($product && !$product->is_virtual()) {
                $weight = $product->get_weight();
                if ($weight) {
                    $total_weight += (float) $weight * (int) $item->get_quantity();
                }
            }
        }

        $weight_unit = get_option('woocommerce_weight_unit');
        if ($total_weight > 0) {
            echo esc_html(number_format_i18n($total_weight, 2)) . ' ' . esc_html($weight_unit);
        } else {
            echo 'N/A';
        }
    }
}

/**
 * Rendre la colonne triable (HPOS: utilise woocommerce_order_query_args si besoin)
 */
add_filter('woocommerce_shop_order_list_table_sortable_columns', 'sortable_order_weight_column_hpos');
function sortable_order_weight_column_hpos($columns) {
    $columns['order_weight'] = 'order_weight';
    return $columns;
}